<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s">
  <div class="panel-body">
    <h4 class="no-margin">Meu QR Code</h4>
    <hr class="hr-panel-heading" />
    <div class="row">
      <div class="col-md-4">
        <img style="max-width: 240px;" src="<?php echo $qr_image_url; ?>" alt="QR Code do cliente" />
        <p style="margin-top:10px;"><strong>Link de destino:</strong> <a href="<?php echo html_escape($qr_link); ?>" target="_blank"><?php echo html_escape($qr_link); ?></a></p>
        <p><strong>Total de acessos:</strong> <?php echo (int)$total; ?></p>
      </div>
      <div class="col-md-8">
        <canvas id="qrClientChart" height="120"></canvas>
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
          (function(){
            var ctx = document.getElementById('qrClientChart').getContext('2d');
            var labels = [<?php foreach($series as $s){ echo '\''.(string)$s->d.'\','; } ?>];
            var data = [<?php foreach($series as $s){ echo (int)$s->c.','; } ?>];
            new Chart(ctx, { type:'bar', data:{ labels: labels, datasets:[{ label:'Acessos (30 dias)', data:data, backgroundColor:'#36b9cc' }] }, options:{ scales:{ y:{ beginAtZero:true } } } });
          })();
        </script>

        <h5 style="margin-top:20px;">Últimos acessos</h5>
        <div class="table-responsive">
          <table class="table table-striped">
            <thead><tr><th>Data</th><th>IP</th><th>Dispositivo</th></tr></thead>
            <tbody>
              <?php foreach($latest as $h): ?>
              <tr>
                <td><?php echo _dt($h->created_at); ?></td>
                <td><?php echo html_escape($h->ip); ?></td>
                <td><?php echo html_escape(substr($h->user_agent,0,80)); ?>...</td>
              </tr>
              <?php endforeach; if (empty($latest)): ?>
              <tr><td colspan="3">Sem registros.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
