<?php
/**
 * Dual Modules Scanner (FCPATH/modules and APPPATH/modules)
 * Coloque este arquivo na raiz do seu Perfex (mesmo nível de index.php) como _scan_all.php
 * Acesse: https://SEU-DOMINIO/.../_scan_all.php
 */
header('Content-Type: text/html; charset=utf-8');
if (!defined('BASEPATH')) define('BASEPATH', __FILE__);

function scanModulesDir($base, $label) {
  echo "<h3 style='margin-top:30px'>".$label." — ".htmlspecialchars($base)."</h3>";
  if (!is_dir($base)) { echo "<p style='color:#c62828'>Diretório não existe.</p>"; return; }
  $items = scandir($base);
  echo "<table border='1' cellpadding='6' cellspacing='0' style='border-collapse:collapse;width:100%'>";
  echo "<tr style='background:#f0f0f0'><th>Entrada</th><th>Tipo</th><th>config.php</th><th>module_name</th><th>Observações</th></tr>";
  foreach ($items as $it) {
    if ($it === '.' || $it === '..') continue;
    $full = rtrim($base,'/').'/'.$it;
    $isDir = is_dir($full);
    $type = $isDir ? 'pasta' : 'arquivo';
    $config = $full.'/config.php';
    $hasConfig = $isDir && file_exists($config);
    $module_name = null; $notes = [];
    if ($isDir && $hasConfig) {
      $module = [];
      try {
        include $config;
      } catch (Throwable $e) {
        $notes[] = "Erro ao incluir config.php: ".$e->getMessage();
      }
      if (isset($module['module_name']) && is_string($module['module_name']) && $module['module_name']!=='') {
        $module_name = $module['module_name'];
      } else {
        if ($isDir) $notes[] = "config.php sem \$module['module_name']";
      }
    } else if ($isDir && !$hasConfig) {
      $notes[] = "pasta sem config.php";
    } else {
      $notes[] = "arquivo solto (ignorar)";
    }
    echo "<tr>";
    echo "<td>".htmlspecialchars($it)."</td>";
    echo "<td>$type</td>";
    echo "<td>".($hasConfig ? 'OK' : 'NÃO')."</td>";
    echo "<td>".($module_name ? htmlspecialchars($module_name) : '<span style=\"color:#c62828\">indefinido</span>')."</td>";
    echo "<td>".(empty($notes)?'-':implode('; ', $notes))."</td>";
    echo "</tr>";
  }
  echo "</table>";
}

$root = __DIR__;
$fcpathModules = $root.'/modules';
$appModules    = $root.'/application/modules';

echo "<div style='max-width:1000px;margin:30px auto;font-family:system-ui,Segoe UI,Arial'>";
echo "<h2>Perfex Dual Modules Scanner</h2>";
scanModulesDir($fcpathModules, 'FCPATH/modules');
scanModulesDir($appModules, 'APPPATH/modules');
echo "</div>";
