<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <h4 class="no-margin">Módulos</h4>
            <hr class="hr-panel-heading" />
            <div class="table-responsive">
              <table class="table dt-table">
                <thead>
                  <tr>
                    <th>Nome</th>
                    <th>Descrição</th>
                    <th>Versão</th>
                    <th>Autor</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                <?php
                $modules = isset($modules) && is_array($modules) ? $modules : [];
                foreach ($modules as $module):
                    // Blindagem contra índices ausentes
                    $name   = $module['module_name'] ?? ($module['name'] ?? ($module['system_name'] ?? 'Módulo sem nome'));
                    $desc   = $module['description']  ?? '-';
                    $ver    = $module['version']      ?? '-';
                    $author = $module['author']       ?? '-';
                    $active = isset($module['activated']) ? (bool)$module['activated'] : false;
                ?>
                  <tr>
                    <td><?php echo html_escape($name); ?></td>
                    <td><?php echo html_escape($desc); ?></td>
                    <td><?php echo html_escape($ver); ?></td>
                    <td><?php echo html_escape($author); ?></td>
                    <td>
                      <?php if ($active): ?>
                        <span class="label label-success">Ativo</span>
                      <?php else: ?>
                        <span class="label label-default">Inativo</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>
            <?php if (empty($modules)): ?>
              <p class="text-muted">Nenhum módulo encontrado em <code>modules/</code>.</p>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php init_tail(); ?>
</body>
</html>
