(function(){
  // Procura primeira tabela relevante na view
  var $table = jQuery('table').first();
  if (!$table.length) return;

  // Troca "Total" -> "Visualizações" no cabeçalho (fallback)
  $table.find('thead th').each(function(){
    var t = jQuery(this).text().trim().toLowerCase();
    if (t === 'total') jQuery(this).text('Visualizações');
  });

  // Funções utilitárias para achar índice de coluna por título
  function findColIdx(possibleLabels){
    var idx = -1;
    $table.find('thead th').each(function(i){
      var t = jQuery(this).text().trim().toLowerCase();
      if (possibleLabels.indexOf(t) >= 0){ idx = i; return false; }
    });
    return idx;
  }
  var nameCol = findColIdx(['cliente','client','nome','name']);
  var hitsCol = findColIdx(['visualizações','visualizacoes','total','hits','leituras']);
  if (nameCol < 0 || hitsCol < 0) return;

  // Injeta a barra de filtros acima da tabela (uma vez só)
  if (jQuery('#qrass-filters').length === 0){
    var $bar = jQuery([
      '<div id="qrass-filters" class="panel_s" style="padding:12px;margin-bottom:10px;">',
      '  <div class="row">',
      '    <div class="col-md-3">',
      '      <label>Cliente</label>',
      '      <input type="text" id="qrassFilterName" class="form-control" placeholder="Buscar por cliente...">',
      '    </div>',
      '    <div class="col-md-2">',
      '      <label>Mín. visualizações</label>',
      '      <input type="number" id="qrassFilterMin" class="form-control" placeholder="ex.: 1" min="0">',
      '    </div>',
      '    <div class="col-md-2">',
      '      <label>Máx. visualizações</label>',
      '      <input type="number" id="qrassFilterMax" class="form-control" placeholder="ex.: 50" min="0">',
      '    </div>',
      '    <div class="col-md-3">',
      '      <label>Ordenar por</label>',
      '      <select id="qrassSortBy" class="form-control">',
      '        <option value="hits_desc">Visualizações (maior → menor)</option>',
      '        <option value="hits_asc">Visualizações (menor → maior)</option>',
      '        <option value="name_asc">Cliente (A → Z)</option>',
      '        <option value="name_desc">Cliente (Z → A)</option>',
      '      </select>',
      '    </div>',
      '    <div class="col-md-2" style="display:flex;gap:8px;align-items:flex-end;">',
      '      <button type="button" id="qrassApplyFilters" class="btn btn-primary">Aplicar</button>',
      '      <button type="button" id="qrassClearFilters" class="btn btn-default">Limpar</button>',
      '    </div>',
      '  </div>',
      '</div>'
    ].join(''));

    $bar.insertBefore($table);
  }

  var $tbody = $table.find('tbody');
  if (!$tbody.length) return;
  var originalRows = $tbody.find('tr').toArray();

  function getRowData(tr){
    var $tds = jQuery(tr).children('td');
    var name = ($tds.eq(nameCol).text()||'').trim().toLowerCase();
    var hits = parseInt(($tds.eq(hitsCol).text()||'0').replace(/\D+/g,''),10) || 0;
    return { name:name, hits:hits };
  }

  function applyFilters(){
    var q   = (jQuery('#qrassFilterName').val()||'').trim().toLowerCase();
    var min = parseInt(jQuery('#qrassFilterMin').val(),10); if (isNaN(min)) min = null;
    var max = parseInt(jQuery('#qrassFilterMax').val(),10); if (isNaN(max)) max = null;

    $tbody.find('tr').each(function(){
      var d = getRowData(this), ok = true;
      if (q && d.name.indexOf(q) === -1) ok = false;
      if (min !== null && d.hits < min)  ok = false;
      if (max !== null && d.hits > max)  ok = false;
      jQuery(this).toggle(ok);
    });

    var sortBy = jQuery('#qrassSortBy').val();
    var rows = $tbody.find('tr:visible').toArray();
    rows.sort(function(a,b){
      var da = getRowData(a), db = getRowData(b);
      switch (sortBy){
        case 'hits_desc': return db.hits - da.hits;
        case 'hits_asc':  return da.hits - db.hits;
        case 'name_desc': return db.name.localeCompare(da.name);
        case 'name_asc':
        default:          return da.name.localeCompare(db.name);
      }
    });
    rows.forEach(function(tr){ $tbody.append(tr); });
    // mantém ocultos no final
    originalRows.forEach(function(tr){ if (jQuery(tr).is(':hidden')) $tbody.append(tr); });
  }

  jQuery('#qrassApplyFilters').on('click', applyFilters);
  jQuery('#qrassClearFilters').on('click', function(){
    jQuery('#qrassFilterName').val('');
    jQuery('#qrassFilterMin').val('');
    jQuery('#qrassFilterMax').val('');
    jQuery('#qrassSortBy').val('hits_desc');
    $tbody.empty();
    originalRows.forEach(function(tr){ $tbody.append(tr); });
    $tbody.find('tr').show();
    // garante cabeçalho
    $table.find('thead th').each(function(){
      var t = jQuery(this).text().trim().toLowerCase();
      if (t === 'total') jQuery(this).text('Visualizações');
    });
  });

})();
