<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Diag extends AdminController
{
    public function check_widget()
    {
        // Only admins
        if (!is_staff_logged_in()) { show_404(); }

        $base = realpath(__DIR__ . '/..'); // modules/qrassociados
        $path = $base . '/views/client/widget_top10.php';

        $exists = file_exists($path);
        $read   = is_readable($path);
        $size   = $exists ? filesize($path) : 0;
        $dir    = $base . '/views/client';

        header('Content-Type: text/plain; charset=utf-8');
        echo "Base module dir: $base\n";
        echo "Expected view path: $path\n";
        echo "file_exists: " . ($exists ? 'YES' : 'NO') . "\n";
        echo "is_readable: " . ($read ? 'YES' : 'NO') . "\n";
        echo "filesize: $size bytes\n";
        echo "Directory listing ($dir):\n";

        if (is_dir($dir)) {
            $items = scandir($dir);
            foreach ($items as $it) {
                echo " - $it\n";
            }
        } else {
            echo " - (directory missing)\n";
        }
    }
}
