<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Patch extends AdminController
{
    /**
     * Aplique este patch indo para /qrassociados/patch/dedup
     * - Requer estar logado como staff (admin).
     * - Cria backup e modifica o arquivo qrassociados.php:
     *   1) Insere guarda global QRASSOC_TOP10_RENDERED dentro de qrassociados_render_view
     *   2) Envolve chamadas diretas a qrassociados_render_view('client/widget_top10', ...) com a guarda
     *   3) Garante include do boot
     */
    public function dedup()
    {
        if (!is_staff_logged_in()) {
            show_error('Acesso restrito (somente staff/admin).', 403);
        }

        $moduleDir = realpath(__DIR__ . '/..'); // modules/qrassociados
        $file = $moduleDir . '/qrassociados.php';

        header('Content-Type: text/plain; charset=utf-8');
        echo "qrassociados Top10 De-dup Patch\n";
        echo "File: $file\n";

        if (!file_exists($file)) {
            echo "ERRO: Arquivo não encontrado.\n";
            return;
        }
        if (!is_readable($file) || !is_writable($file)) {
            echo "ERRO: Sem permissão de leitura/escrita no arquivo.\n";
            return;
        }

        $src = file_get_contents($file);
        $original = $src;
        $changed = false;

        // 0) Backup
        $backup = $file . '.bak.' . date('Ymd_His');
        if (!file_exists($backup)) {
            if (!file_put_contents($backup, $src)) {
                echo "ERRO: Não foi possível criar backup em $backup\n";
                return;
            }
            echo "Backup criado: $backup\n";
        } else {
            echo "Backup já existia: $backup\n";
        }

        // 1) Inserir guarda global dentro da função qrassociados_render_view (se ainda não houver)
        if (strpos($src, 'function qrassociados_render_view') !== false
            && strpos($src, 'QRASSOC_TOP10_RENDERED') === false) {

            // Vamos inserir logo após a abertura da função
            $src = preg_replace_callback(
                '/function\s+qrassociados_render_view\s*\(\s*\$rel\s*,\s*\$vars\s*=\s*\[\]\s*\)\s*\{\s*/',
                function ($m) {
                    $inject =
                        $m[0] .
                        "    // Guarda global para evitar duplicidade do widget Top 10\n" .
                        "    if (\$rel === 'client/widget_top10') {\n" .
                        "        if (defined('QRASSOC_TOP10_RENDERED')) { return; }\n" .
                        "        define('QRASSOC_TOP10_RENDERED', true);\n" .
                        "    }\n";
                    return $inject;
                },
                $src, 1, $count
            );
            if ($count > 0) {
                echo "✔ Inserida guarda global dentro de qrassociados_render_view().\n";
                $changed = true;
            } else {
                echo "ℹ Não foi possível localizar o ponto exato da função para inserir a guarda; seguindo.\n";
            }
        } else {
            echo "ℹ Guarda global já presente dentro de qrassociados_render_view() ou função não encontrada.\n";
        }

        // 2) Proteger chamadas diretas a qrassociados_render_view('client/widget_top10', ...);
        $pattern = '/qrassociados_render_view\s*\(\s*[\'"]client\/widget_top10[\'"]\s*,\s*(.*?)\s*\)\s*;/s';
        if (preg_match_all($pattern, $src, $mm)) {
            $src = preg_replace($pattern,
                'if (!defined(\'QRASSOC_TOP10_RENDERED\')) { define(\'QRASSOC_TOP10_RENDERED\', true); qrassociados_render_view(\'client/widget_top10\', $1); }',
                $src, -1, $rep);
            if ($rep > 0) {
                echo "✔ Protegidas $rep chamadas diretas ao renderizador (com guarda).\n";
                $changed = true;
            }
        } else {
            echo "ℹ Nenhuma chamada direta ao renderizador encontrada (padrão com 2º argumento).\n";
        }

        // Variante sem 2º argumento
        $pattern2 = '/qrassociados_render_view\s*\(\s*[\'"]client\/widget_top10[\'"]\s*\)\s*;/s';
        if (preg_match_all($pattern2, $src, $mm2)) {
            $src = preg_replace($pattern2,
                'if (!defined(\'QRASSOC_TOP10_RENDERED\')) { define(\'QRASSOC_TOP10_RENDERED\', true); qrassociados_render_view(\'client/widget_top10\'); }',
                $src, -1, $rep2);
            if ($rep2 > 0) {
                echo "✔ Protegidas $rep2 chamadas diretas (sem 2º argumento).\n";
                $changed = true;
            }
        } else {
            echo "ℹ Nenhuma chamada direta sem 2º argumento encontrada.\n";
        }

        // 3) Garantir include do boot
        if (strpos($src, "include_once __DIR__ . '/qrassociados_top10_boot.php';") === false) {
            $src .= "\n\ninclude_once __DIR__ . '/qrassociados_top10_boot.php';\n";
            echo "✔ Adicionado include do boot no final do arquivo.\n";
            $changed = true;
        } else {
            echo "ℹ Include do boot já presente.\n";
        }

        if ($changed) {
            if (file_put_contents($file, $src) !== false) {
                echo "OK: Alterações gravadas com sucesso.\n";
            } else {
                echo "ERRO: Falha ao salvar alterações.\n";
            }
        } else {
            echo "Nada para alterar. (Arquivo já estava compatível)\n";
        }

        echo "\nConcluído.\n";
    }
}
