<?php
defined('BASEPATH') or exit('No direct script access allowed');
/**
 * QR Associados — Patch: filtros e renomear coluna para "Visualizações" na listagem admin,
 * sem editar a view original. Este patch injeta um JS apenas quando o controller atual é
 * o do módulo (admin/qrassociados*).
 *
 * Como ativar:
 * 1) Certifique-se de que este arquivo foi extraído em:
 *    modules/qrassociados/patches/admin_ranking_filters.php
 * 2) Edite modules/qrassociados/qrassociados.php e adicione, uma única vez:
 *       require_once __DIR__ . '/patches/admin_ranking_filters.php';
 *    (Dica: coloque no final do arquivo, após outras inclusões do módulo)
 */

hooks()->add_action('app_admin_footer', function () {
    $CI = &get_instance();
    if (!isset($CI->router)) { return; }
    $ctrl  = strtolower($CI->router->class ?? '');
    $is_qr = ($ctrl === 'qrassociados'); // lista/admin do módulo
    if (!$is_qr) { return; }

    // Carrega nosso JS
    $src = module_dir_url('qrassociados', 'assets/js/qrass_admin_ranking_filters.js');
    echo '<script src="' . html_escape($src) . '"></script>';
});
