<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="row">
  <div class="col-md-6">
    <div class="panel_s">
      <div class="panel-body">
        <h4 class="no-margin">QR do Cliente #<?php echo (int)$customer_id; ?></h4>
        <hr class="hr-panel-heading" />
        <img style="max-width: 240px;" src="<?php echo $qr_image_url; ?>" alt="QR Code" />
        <p style="margin-top:10px;"><strong>URL de rastreio:</strong> <a href="<?php echo $track_url; ?>" target="_blank"><?php echo $track_url; ?></a></p>
        <form method="post" action="" class="form">
          <input type="hidden" name="qrassociados_inline_update" value="1" />
          <div class="form-group">
            <label>Link de destino (redirecionamento após rastrear)</label>
            <input type="url" name="destination_url" class="form-control" value="<?php echo html_escape($destination); ?>" placeholder="https://..." />
          </div>
          <button type="submit" class="btn btn-primary">Salvar</button>
        </form>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="panel_s">
      <div class="panel-body">
        <h4 class="no-margin">Estatísticas</h4>
        <hr class="hr-panel-heading" />
        <p><strong>Total de acessos:</strong> <?php echo (int)$total; ?></p>
        <canvas id="qrChart" height="150"></canvas>
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
          (function(){
            var ctx = document.getElementById('qrChart').getContext('2d');
            var labels = [
              <?php foreach($series as $s){ echo '\''.(string)$s->d.'\','; } ?>
            ];
            var data = [
              <?php foreach($series as $s){ echo (int)$s->c.','; } ?>
            ];
            new Chart(ctx, { type:'line', data:{ labels: labels, datasets:[{ label:'Acessos', data:data, borderColor:'#4e73df', fill:false }] }, options:{ scales:{ x:{ display:true }, y:{ beginAtZero:true } } });
          })();
        </script>
      </div>
    </div>
    <div class="panel_s">
      <div class="panel-body">
        <h4 class="no-margin">Últimos acessos</h4>
        <hr class="hr-panel-heading" />
        <div class="table-responsive">
          <table class="table table-striped">
            <thead><tr><th>Data</th><th>IP</th><th>User Agent</th><th>Referrer</th></tr></thead>
            <tbody>
              <?php foreach($latest as $h): ?>
              <tr>
                <td><?php echo _dt($h->created_at); ?></td>
                <td><?php echo html_escape($h->ip); ?></td>
                <td style="max-width:280px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;" title="<?php echo html_escape($h->user_agent); ?>"><?php echo html_escape($h->user_agent); ?></td>
                <td style="max-width:200px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;" title="<?php echo html_escape($h->referrer); ?>"><?php echo html_escape($h->referrer); ?></td>
              </tr>
              <?php endforeach; if (empty($latest)): ?>
              <tr><td colspan="4">Sem registros.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
