<?php defined('BASEPATH') or exit('No direct script access allowed');
$CI =& get_instance();
$CI->load->model('qrassociados/qrassociados_model');

// Identify customer id from the context
$customer_id = 0;
if (isset($client) && is_object($client) && isset($client->userid)) {
    $customer_id = (int)$client->userid;
} elseif (isset($customer_profile) && is_object($customer_profile) && isset($customer_profile->userid)) {
    $customer_id = (int)$customer_profile->userid;
} elseif (isset($userid)) {
    $customer_id = (int)$userid;
}

if ($customer_id <= 0) {
    echo '<div class="alert alert-danger">ID de cliente inválido.</div>';
    return;
}

// Handle POST update first
if ($CI->input->post('qrassociados_inline_update')) {
    $new = trim((string)$CI->input->post('destination_url'));
    if ($new !== '') {
        $CI->qrassociados_model->set_destination_url($customer_id, $new);
        set_alert('success', 'Link de destino atualizado.');
        redirect(admin_url('clients/client/'.$customer_id.'?group=qrassociados_tab'));
        return; // stop rendering
    }
}

// Ensure QR exists
$module_path = FCPATH . 'modules/qrassociados/';
$qr_dir      = $module_path . 'uploads/clients/';
if (!is_dir($qr_dir)) { @mkdir($qr_dir, 0755, true); }
$file_path   = $qr_dir . 'client_' . $customer_id . '.png';
$track_url   = site_url('qrassociados/track/go/'.$customer_id);
if (!file_exists($file_path)) {

    if (!class_exists('QRcode')) {
        if (file_exists($qrlib)) { require_once $qrlib; }
    }
    $done = false;

if (class_exists('QRcode') && method_exists('QRcode','png')) {
    try {
        QRcode::png($track_url, $file_path, QR_ECLEVEL_L, 6, 2);
        if (is_file($file_path) && filesize($file_path) > 0) {
            $done = true;
        }
    } catch (Throwable $e) {}
}

if (!$done) {
    $qr_api = 'https://quickchart.io/qr?text=' . urlencode($track_url) . '&size=300&margin=2';
    $img = @file_get_contents($qr_api);
    if ($img !== false) { @file_put_contents($file_path, $img); }
}

if (!is_file($file_path) || filesize($file_path) === 0) {
    echo '<div class="alert alert-danger">Gerador de QR indisponível no momento.<\/div>';
}

}

$dest   = $CI->qrassociados_model->get_destination_url($customer_id);
$total  = $CI->qrassociados_model->count_hits($customer_id);
$latest = $CI->qrassociados_model->latest_hits($customer_id, 10);
$series = $CI->qrassociados_model->hits_grouped_last_days($customer_id, 30);

$data = [
    'customer_id'  => $customer_id,
    'destination'  => $dest,
    'qr_image_url' => base_url('modules/qrassociados/uploads/clients/client_' . $customer_id . '.png'),
    'track_url'    => $track_url,
    'total'        => $total,
    'latest'       => $latest,
    'series'       => $series,
];

$CI->load->view('qrassociados/admin/customer_tab_inline', $data);
