<?php
// admin_dashboard.php
// Visão geral para o ADMIN ver todos os clientes e alguns dados rápidos.

require_once __DIR__ . '/auth.php';
require_admin();

$user = current_user();
$pdo  = get_pdo();

// Buscar clientes
$sql = "SELECT u.id, u.name, u.email, u.api_token, u.created_at,
        COUNT(l.id) AS total_leads,
        MAX(l.created_at) AS ultimo_lead
        FROM users u
        LEFT JOIN leads l ON l.client_id = u.id
        WHERE u.role = 'client'
        GROUP BY u.id
        ORDER BY u.created_at ASC";
$stmt = $pdo->query($sql);
$clients = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin • Leads Hotspot</title>
  <style>
    body{
      margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
      background:#f3f4f6;
    }
    header{
      background:#0f172a; color:#e5e7eb; padding:12px 20px;
      display:flex; align-items:center; justify-content:space-between;
    }
    header h1{margin:0; font-size:18px;}
    header .user{font-size:13px; color:#9ca3af;}
    header a{color:#f97373; text-decoration:none; font-size:13px;}
    main{padding:18px 20px 24px;}
    table{width:100%; border-collapse:collapse; margin-top:14px; background:#fff;
      border-radius:14px; overflow:hidden; box-shadow:0 10px 25px rgba(15,23,42,.12);}
    th,td{padding:10px 12px; font-size:13px; text-align:left; border-bottom:1px solid #e5e7eb;}
    th{background:#f9fafb; font-weight:600; color:#4b5563;}
    tr:last-child td{border-bottom:none;}
    .pill{display:inline-flex; padding:2px 8px; border-radius:999px; font-size:11px;
      background:#eff6ff; color:#1d4ed8;}
    .small{font-size:12px; color:#6b7280;}
    .tag-token{font-family:monospace; font-size:11px; background:#111827; color:#e5e7eb;
      padding:2px 6px; border-radius:6px;}
    .router-link{font-size:12px;}
  </style>
</head>
<body>
<header>
  <div>
    <h1>Admin • Leads Hotspot</h1>
    <div class="user">Logado como <?= htmlspecialchars($user['name']) ?> (admin)</div>
  </div>
   <div>
    <a href="dashboard.php" style="margin-right:12px;">Ver meus leads</a>
    <a href="profile.php" style="margin-right:12px;">Perfil</a>
    <a href="change_password.php" style="margin-right:12px;">Alterar senha</a>
    <a href="logout.php">Sair</a>
  </div>

</header>

<main>
  <p class="small">Abaixo você enxerga todos os clientes cadastrados, com total de leads,
     último registro e link rápido para gerenciar os roteadores de cada um.</p>

  <table>
    <thead>
      <tr>
        <th>Cliente</th>
        <th>E-mail</th>
        <th>Token API</th>
        <th>Leads</th>
        <th>Último lead</th>
        <th>Roteadores</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($clients as $c): ?>
        <tr>
          <td>
            <?= htmlspecialchars($c['name']) ?><br>
            <span class="small">Criado em <?= htmlspecialchars($c['created_at']) ?></span>
          </td>
          <td><?= htmlspecialchars($c['email']) ?></td>
          <td><span class="tag-token"><?= htmlspecialchars($c['api_token']) ?></span></td>
          <td><?= (int)$c['total_leads'] ?></td>
          <td><?= $c['ultimo_lead'] ? htmlspecialchars($c['ultimo_lead']) : '—' ?></td>
          <td>
            <a class="router-link" href="admin_routers.php?client_id=<?= (int)$c['id'] ?>">Ver roteadores</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</main>
</body>
</html>
