<?php
// admin_routers.php
// Lista e cadastra roteadores de um cliente e mostra status em cards.

require_once __DIR__ . '/auth.php';
require_admin();

$pdo = get_pdo();

$client_id = isset($_GET['client_id']) ? (int)$_GET['client_id'] : 0;
if ($client_id <= 0) {
    die('client_id inválido.');
}

// Busca cliente (usuário cliente)
$stmt = $pdo->prepare('SELECT * FROM users WHERE id = :id LIMIT 1');
$stmt->execute(['id' => $client_id]);
$client = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$client) {
    die('Cliente não encontrado.');
}

// Cadastra novo roteador
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name      = trim($_POST['name'] ?? '');
    $public_ip = trim($_POST['public_ip'] ?? '');
    $ping_port = (int)($_POST['ping_port'] ?? 8291);

    if ($name !== '' && $public_ip !== '') {
        $stmtIns = $pdo->prepare(
            'INSERT INTO routers (client_id, name, public_ip, ping_port, created_at)
             VALUES (:client_id, :name, :public_ip, :ping_port, NOW())'
        );
        $stmtIns->execute([
            'client_id' => $client_id,
            'name'      => $name,
            'public_ip' => $public_ip,
            'ping_port' => $ping_port > 0 ? $ping_port : 8291,
        ]);

        header('Location: admin_routers.php?client_id=' . $client_id);
        exit;
    }
}

// Lista roteadores do cliente
$stmtR = $pdo->prepare('SELECT * FROM routers WHERE client_id = :client_id ORDER BY name ASC');
$stmtR->execute(['client_id' => $client_id]);
$routers = $stmtR->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Roteadores • <?= htmlspecialchars($client['name']) ?></title>
  <style>
    body{
      margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
      background:#f3f4f6;
    }
    header{
      background:#0f172a; color:#e5e7eb; padding:12px 20px;
      display:flex; align-items:center; justify-content:space-between;
    }
    header h1{margin:0; font-size:18px;}
    header .user{font-size:13px; color:#9ca3af;}
    header a{color:#f97373; text-decoration:none; font-size:13px;}
    main{padding:18px 20px 24px;}

    .card{
      background:#fff; border-radius:14px; padding:16px 18px; margin-bottom:18px;
      box-shadow:0 8px 22px rgba(15,23,42,.12); border:1px solid rgba(15,23,42,.06);
    }
    label{display:block; font-size:13px; color:#4b5563; margin-bottom:4px;}
    input{
      width:100%; padding:8px 10px; border-radius:10px; border:1px solid #e5e7eb;
      font-size:13px;
    }
    .row{display:grid; grid-template-columns: 2fr 2fr 1fr auto; gap:10px; align-items:flex-end;}
    @media(max-width:720px){.row{grid-template-columns:1fr}}

    button{
      padding:9px 12px; border-radius:10px; border:0;
      background:#16a34a; color:#fff; font-size:13px; cursor:pointer;
    }

    /* GRID DE DISPOSITIVOS */
    .device-grid{
      display:grid;
      grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
      gap:16px;
    }
    .device-card{
      background:#fff; border-radius:18px; padding:14px 14px 12px;
      box-shadow:0 10px 24px rgba(15,23,42,.14);
      border:1px solid rgba(15,23,42,.08);
      display:flex; flex-direction:column; justify-content:space-between;
      min-height:150px;
    }
    .device-header{
      display:flex; align-items:center; justify-content:space-between; margin-bottom:8px;
    }
    .device-name{font-weight:600; font-size:14px; color:#111827;}
    .device-client{font-size:12px; color:#6b7280;}
    .device-meta{font-size:12px; color:#4b5563; line-height:1.5; margin-top:4px;}
    .device-meta strong{color:#111827;}

    .status-pill{
      display:inline-flex; align-items:center; padding:2px 8px; border-radius:999px;
      font-size:11px; gap:4px;
    }
    .status-dot{
      width:8px; height:8px; border-radius:999px; background:#9ca3af;
    }
    .online{background:#dcfce7; color:#166534;}
    .online .status-dot{background:#16a34a;}
    .offline{background:#fee2e2; color:#b91c1c;}
    .offline .status-dot{background:#ef4444;}
    .unknown{background:#e5e7eb; color:#374151;}
    .unknown .status-dot{background:#9ca3af;}

    .small{font-size:12px; color:#6b7280;}

    .device-footer{
      margin-top:10px; display:flex; justify-content:space-between; align-items:center;
    }
    .btn-check{
      padding:6px 10px; font-size:12px; border-radius:999px; border:0;
      background:#0ea5e9; color:#fff; cursor:pointer; text-decoration:none;
      white-space:nowrap;
    }
  </style>
</head>
<body>
<header>
  <div>
    <h1>Roteadores • <?= htmlspecialchars($client['name']) ?></h1>
    <div class="user">Admin • acompanhamento de Mikrotik (online/offline)</div>
  </div>
  <div>
    <a href="admin_dashboard.php" style="margin-right:12px;">Voltar ao Admin</a>
    <a href="logout.php">Sair</a>
  </div>
</header>

<main>
  <!-- Card de cadastro de novo roteador -->
  <div class="card">
    <form method="post">
      <div class="row">
        <div>
          <label>Nome do roteador / loja</label>
          <input type="text" name="name" placeholder="Ex.: Loja Centro" required>
        </div>
        <div>
          <label>IP / Host público do Mikrotik</label>
          <input type="text" name="public_ip" placeholder="exemplo.dominio.com.br ou IP" required>
        </div>
        <div>
          <label>Porta de teste (TCP)</label>
          <input type="number" name="ping_port" value="8291" min="1" max="65535">
        </div>
        <div>
          <button type="submit">Adicionar roteador</button>
        </div>
      </div>
    </form>
  </div>

  <!-- Cards de status -->
  <?php if ($routers): ?>
    <div class="device-grid">
      <?php foreach ($routers as $r): ?>
        <?php
          $status = $r['last_status'] ?? 'unknown';
          $class  = $status === 'online'
              ? 'online'
              : ($status === 'offline' ? 'offline' : 'unknown');
          $label  = $status === 'online'
              ? 'Online'
              : ($status === 'offline' ? 'Offline' : 'Desconhecido');
        ?>
        <article class="device-card">
          <div>
            <div class="device-header">
              <div>
                <div class="device-name"><?= htmlspecialchars($r['name']) ?></div>
                <div class="device-client"><?= htmlspecialchars($client['name']) ?></div>
              </div>
              <span class="status-pill <?= $class ?>">
                <span class="status-dot"></span>
                <?= $label ?>
              </span>
            </div>

            <div class="device-meta">
              <div><strong>Host:</strong> <?= htmlspecialchars($r['public_ip']) ?></div>
              <div><strong>Porta teste:</strong> <?= (int)$r['ping_port'] ?></div>
              <div>
                <strong>Última checagem:</strong>
                <?php if (!empty($r['last_checked_at'])): ?>
                  <span class="small"><?= htmlspecialchars($r['last_checked_at']) ?></span>
                <?php else: ?>
                  <span class="small">Nunca checado</span>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <div class="device-footer">
            <a class="btn-check"
               href="check_router.php?id=<?= (int)$r['id'] ?>&client_id=<?= $client_id ?>">
              Checar agora
            </a>
          </div>
        </article>
      <?php endforeach; ?>
    </div>
  <?php else: ?>
    <p class="small">Nenhum roteador cadastrado ainda para este cliente.</p>
  <?php endif; ?>
</main>
</body>
</html>
