<?php
// change_password.php
require_once __DIR__ . '/auth.php';
require_login();

$user = current_user();
$pdo  = get_pdo();

$success = '';
$error   = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current = $_POST['current_password'] ?? '';
    $new1    = $_POST['new_password'] ?? '';
    $new2    = $_POST['new_password_confirm'] ?? '';

    if ($new1 === '' || $new2 === '' || $current === '') {
        $error = 'Preencha todos os campos.';
    } elseif ($new1 !== $new2) {
        $error = 'A confirmação de senha não confere.';
    } elseif (strlen($new1) < 6) {
        $error = 'Defina uma senha com pelo menos 6 caracteres.';
    } else {
        // Verifica senha atual
        $okCurrent = password_verify($current, $user['password_hash']);

        // fallback especial apenas para o admin padrão, caso ainda esteja com a senha inicial
        $defaultAdminHash = '$2y$10$kgbmqVZ3h64Or4/Ew7lyQOZ7r3uD4r3IigDXb8bzpRPmU7OITnHte';
        if (!$okCurrent && $user['email'] === 'admin@exemplo.com'
            && $user['password_hash'] === $defaultAdminHash
            && $current === 'admin123') {
            $okCurrent = true;
        }

        if (!$okCurrent) {
            $error = 'Senha atual incorreta.';
        } else {
            $newHash = password_hash($new1, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare('UPDATE users SET password_hash = :hash WHERE id = :id');
            $stmt->execute([
                'hash' => $newHash,
                'id'   => $user['id'],
            ]);
            $success = 'Senha alterada com sucesso!';
            // Atualiza usuário em memória
            $user = current_user();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Alterar senha • Leads Hotspot</title>
  <style>
    body{
      margin:0;
      font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
      background:#f3f4f6;
    }
    header{
      background:#0f172a; color:#e5e7eb; padding:12px 20px;
      display:flex; align-items:center; justify-content:space-between;
    }
    header h1{margin:0; font-size:18px;}
    header .user{font-size:13px; color:#9ca3af;}
    header a{color:#f97373; text-decoration:none; font-size:13px; margin-left:12px;}
    main{padding:18px 20px 24px;}
    .card{
      max-width:420px; background:#fff; border-radius:14px; padding:18px 18px 16px;
      border:1px solid rgba(15,23,42,.06);
      box-shadow:0 8px 22px rgba(15,23,42,.12);
    }
    label{display:block; font-size:13px; margin-bottom:4px; color:#4b5563;}
    input{
      width:100%; padding:7px 9px; border-radius:10px;
      border:1px solid #e5e7eb; font-size:13px;
    }
    input:focus{
      border-color:#2563eb; outline:none;
      box-shadow:0 0 0 1px rgba(37,99,235,.35);
    }
    .field{margin-bottom:12px;}
    button{
      padding:8px 14px; border-radius:999px; border:0; cursor:pointer;
      background:#2563eb; color:#fff; font-size:13px; font-weight:500;
    }
    .msg-ok{
      margin-bottom:10px; padding:8px 10px; border-radius:10px;
      background:#ecfdf5; color:#166534; font-size:13px;
      border:1px solid #bbf7d0;
    }
    .msg-err{
      margin-bottom:10px; padding:8px 10px; border-radius:10px;
      background:#fef2f2; color:#991b1b; font-size:13px;
      border:1px solid #fecaca;
    }
  </style>
</head>
<body>
<header>
  <div>
    <h1>Alterar senha</h1>
    <div class="user">Logado como <?= htmlspecialchars($user['name']) ?> (<?= htmlspecialchars($user['email']) ?>)</div>
  </div>
  <div>
    <?php if (is_admin()): ?>
      <a href="admin_dashboard.php">Admin</a>
    <?php endif; ?>
    <a href="dashboard.php">Meus leads</a>
    <a href="logout.php">Sair</a>
  </div>
</header>

<main>
  <div class="card">
    <?php if ($success): ?>
      <div class="msg-ok"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>
    <?php if ($error): ?>
      <div class="msg-err"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" action="change_password.php" autocomplete="off">
      <div class="field">
        <label for="current_password">Senha atual</label>
        <input type="password" id="current_password" name="current_password" required>
      </div>
      <div class="field">
        <label for="new_password">Nova senha</label>
        <input type="password" id="new_password" name="new_password" required>
      </div>
      <div class="field">
        <label for="new_password_confirm">Confirmar nova senha</label>
        <input type="password" id="new_password_confirm" name="new_password_confirm" required>
      </div>
      <button type="submit">Salvar nova senha</button>
    </form>
  </div>
</main>
</body>
</html>
