<?php
// check_router.php
// Faz um teste simples de conexão TCP ao roteador e grava status na tabela.

require_once __DIR__ . '/auth.php';
require_admin();

$pdo = get_pdo();
$id  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$client_id = isset($_GET['client_id']) ? (int)$_GET['client_id'] : 0;

if ($id <= 0) {
    die('ID inválido.');
}

$stmt = $pdo->prepare('SELECT * FROM routers WHERE id = :id LIMIT 1');
$stmt->execute(['id' => $id]);
$router = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$router) {
    die('Roteador não encontrado.');
}

$host = $router['public_ip'];
$port = (int)$router['ping_port'];
$status = 'offline';

$errno = 0;
$errstr = '';
$timeout = 5;

$connection = @fsockopen($host, $port, $errno, $errstr, $timeout);
if ($connection) {
    $status = 'online';
    fclose($connection);
} else {
    $status = 'offline';
}

$stmtUp = $pdo->prepare('UPDATE routers SET last_status = :status, last_checked_at = NOW() WHERE id = :id');
$stmtUp->execute([
    'status' => $status,
    'id' => $id,
]);

if ($client_id > 0) {
    header('Location: admin_routers.php?client_id=' . $client_id);
} else {
    echo 'Status atualizado: ' . htmlspecialchars($status);
}
exit;
