<?php
// collect_lead.php
// Endpoint chamado pelo login.html do hotspot para registrar leads.

require_once __DIR__ . '/auth.php';

header('Content-Type: application/json; charset=utf-8');

// Permitir somente POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Método não permitido']);
    exit;
}

// Identificação do cliente via token (query string)
$token = $_GET['token'] ?? '';
if (!$token) {
    // Não bloqueia o login do hotspot, apenas registra erro simples
    echo json_encode(['status' => 'error', 'message' => 'Token ausente']);
    exit;
}

$user = find_user_by_token($token);
if (!$user) {
    echo json_encode(['status' => 'error', 'message' => 'Token inválido']);
    exit;
}

// Dados do corpo (JSON ou form-data)
$raw = file_get_contents('php://input');
$data = [];
if ($raw) {
    $json = json_decode($raw, true);
    if (is_array($json)) {
        $data = $json;
    }
}

// Fallback para form-data se necessário
if (empty($data) && !empty($_POST)) {
    $data = $_POST;
}

$email    = trim($data['email'] ?? '');
$whats    = trim($data['whatsapp'] ?? '');
$ip       = $_SERVER['REMOTE_ADDR'] ?? '';
$mac      = trim($data['mac'] ?? '');
$ua       = trim($data['userAgent'] ?? '');
$ssid     = trim($data['ssid'] ?? '');
$router   = trim($data['router'] ?? '');

if ($email === '' && $whats === '') {
    echo json_encode(['status' => 'error', 'message' => 'Dados vazios']);
    exit;
}

$pdo = get_pdo();
$stmt = $pdo->prepare('
    INSERT INTO leads (client_id, email, whatsapp, ip, mac, user_agent, source_ssid, source_router, created_at)
    VALUES (:client_id, :email, :whatsapp, :ip, :mac, :ua, :ssid, :router, NOW())
');
$stmt->execute([
    'client_id' => $user['id'],
    'email'     => $email,
    'whatsapp'  => $whats,
    'ip'        => $ip,
    'mac'       => $mac,
    'ua'        => $ua,
    'ssid'      => $ssid,
    'router'    => $router,
]);

echo json_encode(['status' => 'ok']);
