<?php
// dashboard.php
require_once __DIR__ . '/auth.php';
require_login();

$user = current_user();

$pdo = get_pdo();

// Filtros simples por data
$start = $_GET['start'] ?? '';
$end   = $_GET['end'] ?? '';

$params = ['client_id' => $user['id']];
$where = 'WHERE client_id = :client_id';

if ($start !== '') {
    $where .= ' AND created_at >= :start';
    $params['start'] = $start . ' 00:00:00';
}
if ($end !== '') {
    $where .= ' AND created_at <= :end';
    $params['end'] = $end . ' 23:59:59';
}

// Busca dos leads (limit 500 por segurança)
$sql = "SELECT * FROM leads $where ORDER BY created_at DESC LIMIT 500";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$leads = $stmt->fetchAll();

// Contador total
$stmtCount = $pdo->prepare("SELECT COUNT(*) AS total FROM leads WHERE client_id = :client_id");
$stmtCount->execute(['client_id' => $user['id']]);
$total = (int)$stmtCount->fetch()['total'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dashboard • Leads Hotspot</title>
  <style>
    body{
      margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
      background:#f3f4f6;
    }
    header{
      background:#0f172a; color:#e5e7eb; padding:12px 20px;
      display:flex; align-items:center; justify-content:space-between;
    }
    header h1{margin:0; font-size:18px;}
    header .user{font-size:13px; color:#9ca3af;}
    header a{color:#f97373; text-decoration:none; font-size:13px;}
    main{padding:18px 20px 24px;}
    .card{
      background:#fff; border-radius:14px; padding:14px 14px 10px;
      border:1px solid rgba(15,23,42,.06);
      box-shadow:0 6px 18px rgba(15,23,42,.10);
      margin-bottom:18px;
    }
    .filters{
      display:flex; flex-wrap:wrap; gap:10px; align-items:flex-end;
      font-size:13px;
    }
    .filters label{display:block; margin-bottom:2px; color:#4b5563;}
    .filters input{
      padding:6px 8px; border-radius:8px; border:1px solid #e5e7eb;
      font-size:13px;
    }
    .filters button{
      padding:7px 12px; border-radius:8px; border:0; cursor:pointer;
      background:#2563eb; color:#fff; font-size:13px; font-weight:500;
    }
    .summary{font-size:13px; color:#6b7280; margin-top:10px;}
    table{
      width:100%; border-collapse:collapse; margin-top:10px; font-size:13px;
    }
    th, td{
      padding:8px 6px; border-bottom:1px solid #e5e7eb; text-align:left;
    }
    th{background:#f9fafb; font-weight:600; color:#4b5563;}
    tr:nth-child(even) td{background:#f9fafb;}
    .small{font-size:11px; color:#9ca3af;}
    @media (max-width:740px){
      table, thead, tbody, th, td, tr{display:block;}
      thead{display:none;}
      tr{border:1px solid #e5e7eb; border-radius:10px; margin-bottom:10px; background:#fff;}
      td{border-bottom:0; padding:6px 10px;}
      td::before{
        content:attr(data-label) ': '; font-weight:600; color:#4b5563; display:block;
      }
    }
  </style>
</head>
<body>
<header>
  <div>
    <h1>Leads do Wi‑Fi</h1>
    <div class="user">
      <?= htmlspecialchars($user['name']) ?> • API Token: 
      <code><?= htmlspecialchars($user['api_token']) ?></code>
    </div>
  </div>
    <div>
    <?php if (is_admin()): ?>
      <a href="admin_dashboard.php" style="margin-right:12px;">Admin</a>
    <?php endif; ?>
    <a href="profile.php" style="margin-right:12px;">Perfil</a>
    <a href="change_password.php" style="margin-right:12px;">Alterar senha</a>
    <a href="logout.php">Sair</a>
  </div>
</header>

<main>
  <div class="card">
    <form class="filters" method="get" action="dashboard.php">
      <div>
        <label for="start">De:</label>
        <input type="date" id="start" name="start" value="<?= htmlspecialchars($start) ?>">
      </div>
      <div>
        <label for="end">Até:</label>
        <input type="date" id="end" name="end" value="<?= htmlspecialchars($end) ?>">
      </div>
      <button type="submit">Filtrar</button>
    </form>
    <div class="summary">
      Total de leads: <strong><?= $total ?></strong> • Exibindo <?= count($leads) ?> últimos registros.
    </div>
  </div>

  <div class="card">
    <?php if (empty($leads)): ?>
      <p style="font-size:13px; color:#6b7280;">Nenhum lead encontrado ainda. Aguarde conexões no Wi‑Fi.</p>
    <?php else: ?>
      <table>
        <thead>
          <tr>
            <th>Data</th>
            <th>E-mail</th>
            <th>WhatsApp</th>
            <th>IP / MAC</th>
            <th>Origem</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($leads as $lead): ?>
          <tr>
            <td data-label="Data"><?= htmlspecialchars($lead['created_at']) ?></td>
            <td data-label="E-mail"><?= htmlspecialchars($lead['email']) ?></td>
            <td data-label="WhatsApp"><?= htmlspecialchars($lead['whatsapp']) ?></td>
            <td data-label="IP / MAC">
              <div><?= htmlspecialchars($lead['ip']) ?></div>
              <div class="small"><?= htmlspecialchars($lead['mac']) ?></div>
            </td>
            <td data-label="Origem">
              <div class="small">
                SSID: <?= htmlspecialchars($lead['source_ssid'] ?? '') ?><br>
                Roteador: <?= htmlspecialchars($lead['source_router'] ?? '') ?>
              </div>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>
</main>
</body>
</html>
