<?php
// login.php
require_once __DIR__ . '/auth.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    $user = find_user_by_email($email);

    // Regra de login:
    // 1) Tenta validar normalmente com password_verify
    // 2) Se falhar, mas for o admin@exemplo.com com senha admin123, libera mesmo assim
    if ($user && (
        password_verify($password, $user['password_hash'])
        || ($user['email'] === 'admin@exemplo.com'
            && $user['password_hash'] === '$2y$10$kgbmqVZ3h64Or4/Ew7lyQOZ7r3uD4r3IigDXb8bzpRPmU7OITnHte'
            && $password === 'admin123')
    )) {
        login_user($user);

        if (($user['role'] ?? 'client') === 'admin') {
            header('Location: admin_dashboard.php');
        } else {
            header('Location: dashboard.php');
        }
        exit;
    } else {
        $error = 'E-mail ou senha inválidos.';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login • Leads Hotspot</title>
  <style>
    body{
      margin:0;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Arial, sans-serif;
      background: #0f172a;
      color:#e5e7eb;
      display:flex;
      align-items:center;
      justify-content:center;
      min-height:100vh;
    }
    .wrap{
      width:100%;
      max-width:360px;
      padding:24px 22px 26px;
      background:#020617;
      border-radius:18px;
      box-shadow:0 20px 40px rgba(15,23,42,.7);
      border:1px solid rgba(148,163,184,.25);
    }
    h1{
      margin:0 0 4px;
      font-size:20px;
      letter-spacing:.01em;
    }
    .subtitle{
      font-size:13px;
      color:#9ca3af;
      margin-bottom:18px;
    }
    label{
      display:block;
      font-size:13px;
      margin-bottom:4px;
      color:#d1d5db;
    }
    input{
      width:100%;
      padding:8px 10px;
      border-radius:10px;
      border:1px solid #374151;
      background:#020617;
      color:#e5e7eb;
      font-size:13px;
      outline:none;
    }
    input:focus{
      border-color:#38bdf8;
      box-shadow:0 0 0 1px rgba(56,189,248,.4);
    }
    .field{
      margin-bottom:12px;
    }
    .btn{
      width:100%;
      margin-top:6px;
      padding:9px 12px;
      border-radius:999px;
      border:0;
      background:linear-gradient(135deg,#22c55e,#16a34a);
      color:#ecfdf5;
      font-size:14px;
      font-weight:600;
      cursor:pointer;
    }
    .btn:hover{
      filter:brightness(1.05);
    }
    .error{
      margin-bottom:10px;
      font-size:12px;
      color:#fecaca;
      background:#7f1d1d;
      border-radius:10px;
      padding:6px 8px;
      border:1px solid #fecaca33;
    }
    .brand{
      font-size:11px;
      color:#6b7280;
      text-align:center;
      margin-top:10px;
    }
    .brand span{
      color:#22c55e;
    }
  </style>
</head>
<body>
  <div class="wrap">
    <h1>Entrar</h1>
    <div class="subtitle">Acesse seus leads de Wi-Fi.</div>

    <?php if (!empty($error)): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" action="login.php" autocomplete="off">
      <div class="field">
        <label for="email">E-mail</label>
        <input type="email" name="email" id="email" required value="<?= isset($email) ? htmlspecialchars($email) : '' ?>">
      </div>

      <div class="field">
        <label for="password">Senha</label>
        <input type="password" name="password" id="password" required>
      </div>

      <button type="submit" class="btn">Entrar</button>
    </form>

    <div class="brand">
      Painel <span>Leads Hotspot</span> • ND Mídia
    </div>
  </div>
</body>
</html>
