<?php
// profile.php
// Tela para o usuário editar nome + e-mail.

require_once __DIR__ . '/auth.php';
require_login();

$user = current_user();
$pdo  = get_pdo();

$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name  = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');

    if ($name === '') {
        $errors[] = 'Informe um nome.';
    }
    if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'Informe um e-mail válido.';
    }

    if (!$errors) {
        // Checa se já existe outro usuário com o mesmo e-mail
        $stmt = $pdo->prepare('SELECT id FROM users WHERE email = :email AND id != :id LIMIT 1');
        $stmt->execute([
            'email' => $email,
            'id'    => $user['id'],
        ]);
        if ($stmt->fetch()) {
            $errors[] = 'Já existe outro usuário com este e-mail.';
        } else {
            $stmtUp = $pdo->prepare('UPDATE users SET name = :name, email = :email WHERE id = :id');
            $stmtUp->execute([
                'name'  => $name,
                'email' => $email,
                'id'    => $user['id'],
            ]);
            $success = 'Dados atualizados com sucesso.';
            // recarrega usuário atualizado
            $user = current_user();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Meu perfil • Leads Wi-Fi</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body{
      margin:0; font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;
      background:#f3f4f6;
    }
    header{
      background:#0f172a; color:#e5e7eb; padding:12px 20px;
      display:flex; align-items:center; justify-content:space-between;
    }
    header h1{margin:0; font-size:18px;}
    header .user{font-size:13px; color:#9ca3af;}
    header a{color:#f97373; text-decoration:none; font-size:13px;}
    main{padding:18px 20px 24px;}
    .card{
      max-width:480px;
      background:#fff; border-radius:14px; padding:20px 22px; margin:0 auto;
      box-shadow:0 8px 22px rgba(15,23,42,.12); border:1px solid rgba(15,23,42,.06);
    }
    label{display:block; font-size:13px; color:#4b5563; margin-bottom:4px;}
    input{
      width:100%; padding:8px 10px; border-radius:10px; border:1px solid #e5e7eb;
      font-size:14px; margin-bottom:10px;
    }
    button{
      padding:9px 14px; border-radius:10px; border:0;
      background:#0ea5e9; color:#fff; font-size:14px; cursor:pointer;
    }
    .msg-error{
      background:#fee2e2; color:#b91c1c; padding:8px 10px;
      border-radius:10px; font-size:13px; margin-bottom:10px;
    }
    .msg-success{
      background:#dcfce7; color:#166534; padding:8px 10px;
      border-radius:10px; font-size:13px; margin-bottom:10px;
    }
  </style>
</head>
<body>
<header>
  <div>
    <h1>Meu perfil</h1>
    <div class="user"><?= htmlspecialchars($user['email']) ?></div>
  </div>
  <div>
    <a href="dashboard.php" style="margin-right:12px;">Leads</a>
    <?php if (is_admin()): ?>
      <a href="admin_dashboard.php" style="margin-right:12px;">Admin</a>
    <?php endif; ?>
    <a href="logout.php">Sair</a>
  </div>
</header>

<main>
  <div class="card">
    <?php if ($errors): ?>
      <div class="msg-error">
        <?php foreach ($errors as $e): ?>
          <div><?= htmlspecialchars($e) ?></div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

    <?php if ($success): ?>
      <div class="msg-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <form method="post" autocomplete="off">
      <div>
        <label>Nome</label>
        <input type="text" name="name" value="<?= htmlspecialchars($user['name']) ?>" required>
      </div>
      <div>
        <label>E-mail</label>
        <input type="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required>
      </div>
      <button type="submit">Salvar alterações</button>
    </form>
  </div>
</main>
</body>
</html>
